<?php

class Ultimate_AI_license_controller{
    public $license;
    public function __construct(){
        add_action( 'wp_ajax_ultimate_ai_activate_license', [ $this, 'ultimate_ai_activate_license' ] );
        add_action( 'wp_ajax_ultimate_ai_deactivate_license', [ $this, 'ultimate_ai_deactivate_license' ] );
        add_action( 'wp_ajax_ultimate_ai_verify_license', [ $this, 'ultimate_ai_verify_license' ] );
        add_action( 'wp_ajax_ultimate_ai_license_data', [ $this, 'ultimate_ai_license_data' ] );
        add_action( 'wp_ajax_ultimate_ai_update_licence', [ $this, 'ultimate_ai_update_licence' ] );
        $this->license = new Ultimate_AI_License();
    }
    public function ultimate_ai_update_licence(){
		$purchasekey = $_POST['purchase_key'];
		$licencekey = $_POST['licence_key'];
		if( !isset( $purchasekey ) || empty( $purchasekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid purchase key", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
		if( !isset( $licencekey ) || empty( $licencekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid licence key.", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
		$purchasekeyupdated = update_option( 'uai_activation_key', $purchasekey);
		$licencekeyupdated = update_option( 'uai_licence_key', $licencekey);
		
		if( $purchasekey && $licencekey ){
			$response = [
				"message" => __("Successfully updated"),
				"updated" => true
			];
			wp_send_json( $response, 200 );
		}
	}
    public function ultimate_ai_activate_license(){
        $key = sanitize_text_field( $_POST['licencekey'] );
        $res = $this->license->activate_licence( $key );
        
        wp_send_json( $res, 200 );
    }
    public function ultimate_ai_deactivate_license(){

        restrict_req_for_admin();

        $purchasekey = get_option( 'uai_activation_key', false );
        $licencekey = get_option( 'uai_licence_key', false );
        
		if( empty( $purchasekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid purchase key", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
		if( empty( $licencekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid licence key.", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
        $deactivate = $this->license->deactivate_licence( $purchasekey, $licencekey );
        if( $deactivate->deactivated ){
            $purchasekeyupdated = update_option( 'uai_activation_key', '');
            $licencekeyupdated = update_option( 'uai_licence_key', '');
        }
        
        wp_send_json( $deactivate, 200 );
    }
    public function ultimate_ai_license_data(){
        // check if key is send or not
        $purchasekey = get_option( 'uai_activation_key', false );
        $licencekey = get_option( 'uai_licence_key', false );
        
		if( empty( $purchasekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid purchase key", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
		if( empty( $licencekey ) ) {
			wp_send_json(
				[
					"verified"  => false,
					"message"   => esc_html__("Invalid licence key.", ULTIMATE_AI_SLUG),
				],
				200
			);
		}
        
        try{
            wp_send_json( [
                'purchase_key' => $purchasekey, 
                'licence_key' => $licencekey
            ], 200 );
        }catch( Exception $e ) {
			wp_send_json(
				[
					"message" => $e->getMessage()
				],
				400
			);
		}
    }
}

new Ultimate_AI_license_controller();